<?php
/* --------------------------------------------------------------
  OnGetSellingUnitEanEventListener.php 2020-02-24
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2020 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Shop\Attributes\SellingUnitEan\Listener;

use Gambio\Shop\Attributes\SellingUnitEan\Repository\Dto\EanCollectionDto;
use Gambio\Shop\Attributes\SellingUnitEan\Service\ReadServiceInterface;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitEanEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Ean;

/**
 * Class OnGetSellingUnitEanEventListener
 * @package Gambio\Shop\Attributes\SellingUnitEan\Listener
 */
class OnGetSellingUnitEanEventListener
{
    /**
     * @var ReadServiceInterface
     */
    protected $service;
    
    
    public function __construct(
        ReadServiceInterface $service
    
    ) {
        $this->service = $service;
    }
    
    
    /**
     *
     * @param OnGetSellingUnitEanEventInterface $event
     *
     */
    public function __invoke(OnGetSellingUnitEanEventInterface $event)
    {
        $productId = $event->productId();
        $modifiers = $event->modifierIdentifiers();
        if (count($modifiers)) {
            $ean                  = $event->ean()->value();
            $productAttributeEans = $this->service->getAttributesEanValuesByProduct($productId, $modifiers);
            /** @var EanCollectionDto $productAttributeEans */
            if ($productAttributeEans->count() > 0) {
                $eanDtos = $productAttributeEans->jsonSerialize();
                foreach ($eanDtos as $key => $value) {
                    if ($key !== count($productAttributeEans)) {
                        $ean .= '-';
                    }
                    $ean .= $value->value();
                }
            }
            $event->setEan(new Ean($ean));
        }
    }
    
}